#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Headers/NSWFL.H"
#include "../Headers/Package.H"
#include "../Headers/Entry.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/ReadingDlg.H"
#include "../Dialogs/PackingDlg.H"
#include "../Dialogs/ExtractDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND MainDialog_hWnd = NULL;
HWND FileList_hWnd = NULL;
HWND StatusBar_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HBRUSH BGColor = CreateSolidBrush( RGB(212, 208, 200) );

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define IDM_NEW        1000
#define IDM_OPEN       1001
#define IDM_ADD        1002
#define IDM_DELETE     1003
#define IDM_EXTRACT    1004
#define IDM_VIEW       1005
#define IDM_PROPERTIES 1006
#define IDM_OPTIONS    1007
#define IDM_HELP       1008
#define IDM_EXIT       1009

#define ID_MYTOOLBAR   2000

#define BTIcons        10
#define TBButtons      13
#define TBLength       36
#define TBWidth        36

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

TBBUTTON tbb[] = {
    {0, IDM_NEW, 0, TBSTYLE_BUTTON, 0, 0},
    {1, IDM_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {2, IDM_ADD, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {3, IDM_DELETE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {4, IDM_EXTRACT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {5, IDM_VIEW, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {6, IDM_PROPERTIES, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {7, IDM_OPTIONS, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {8, IDM_HELP, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {9, IDM_EXIT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0}
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HWND CreateToolBar(HWND hWnd)
{
    HWND hTool     = NULL;
    HBITMAP BitMap = NULL;

    InitCommonControls();

    if(! (BitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TOOLBAR) )) )
        ErrorMessage(hWnd, "Failed to load bitmap");

    hTool = CreateToolbarEx(
        hWnd,
        WS_CHILD|WS_VISIBLE|TBSTYLE_TOOLTIPS|TBSTYLE_FLAT|TBSTYLE_TOOLTIPS,
        ID_MYTOOLBAR,
        BTIcons,
        NULL,
        (DWORD)BitMap,
        tbb,
        0,
        TBLength, TBWidth,
        TBLength, TBWidth,
        sizeof(TBBUTTON)
    );

    tbb[0].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "New");
    tbb[1].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Open");

    tbb[3].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Add");
    tbb[4].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Delete");
    tbb[5].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Extract");

    tbb[7].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "View");
    tbb[8].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Properties");

    tbb[10].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Options");
    tbb[11].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Help");
    tbb[12].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Exit");

    SendMessage(hTool, TB_ADDBUTTONS, TBButtons, (LONG)&tbb);
    SendMessage(hTool, TB_AUTOSIZE, 0, 0);

    return hTool;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;
    static HWND MainToolBar_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        FileList_hWnd = GetDlgItem(xHandle, IDC_FILELIST);
        MainToolBar_hWnd = CreateToolBar(xHandle);

        SendMessage(FileList_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
        ListView_SetTextColor(FileList_hWnd, RGB(0,0,100));

        LV_COLUMN MyLVColumb;

        memset(&MyLVColumb, 0, sizeof(LV_COLUMN));

        MyLVColumb.cx        = 200;
        MyLVColumb.pszText   = "Name";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Type";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 1, &MyLVColumb);

        MyLVColumb.cx        = 125;
        MyLVColumb.pszText   = "Modified";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 2, &MyLVColumb);

        MyLVColumb.cx        = 65;
        MyLVColumb.pszText   = "Size";
        MyLVColumb.iSubItem  = 3;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_RIGHT;
        ListView_InsertColumn(FileList_hWnd, 3, &MyLVColumb);

        MyLVColumb.cx        = 50;
        MyLVColumb.pszText   = "Ratio";
        MyLVColumb.iSubItem  = 4;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 4, &MyLVColumb);

        MyLVColumb.cx        = 65;
        MyLVColumb.pszText   = "Packed";
        MyLVColumb.iSubItem  = 5;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_RIGHT;
        ListView_InsertColumn(FileList_hWnd, 5, &MyLVColumb);

        MyLVColumb.cx        = 75;
        MyLVColumb.pszText   = "CRC";
        MyLVColumb.iSubItem  = 6;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 6, &MyLVColumb);

        MyLVColumb.cx        = 75;
        MyLVColumb.pszText   = "Attributes";
        MyLVColumb.iSubItem  = 7;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 7, &MyLVColumb);

        MyLVColumb.cx        = 300;
        MyLVColumb.pszText   = "Path";
        MyLVColumb.iSubItem  = 8;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 8, &MyLVColumb);

        StatusBar_hWnd = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Ready", xHandle, 1);

        CenterWindow(xHandle);

        RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(FileList_hWnd, 0, 70, WindowRECT.right, WindowRECT.bottom - 91, TRUE);
        MoveWindow(StatusBar_hWnd, WindowRECT.right-20, WindowRECT.bottom-20, WindowRECT.right, WindowRECT.bottom, TRUE);

        if(gdwCurrentJobType == JOB_TYPE_READING)
        {
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_READING), NULL, ReadingDialog) != 1)
            {
                EndDialog(xHandle, 0);
                DestroyWindow(xHandle);
            }
        }
        else if(gdwCurrentJobType == JOB_TYPE_PACKING) {
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_PACKING), NULL, PackingDialog) != 1)
            {
                EndDialog(xHandle, 0);
                DestroyWindow(xHandle);
            }
            else {
                // View an existing archive
                gdwCurrentJobType = JOB_TYPE_READING;
                Worker_Thread_Handle = CreateThread(NULL, 0, ViewExisting_Worker_Thread, (LPVOID) gsWorkingOutput, 0, &Worker_Thread_ID);
                if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_READING), NULL, ReadingDialog) != 1)
                {
                    EndDialog(xHandle, 0);
                    DestroyWindow(xHandle);
                }
            }
        }
        else{
            ResumeThread(Worker_Thread_Handle);
        }

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CTLCOLORDLG)
        return (LONG)BGColor;

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE)
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);

        MoveWindow(FileList_hWnd, 0, 70, nWidth, nHeight - 91, TRUE);
        MoveWindow(StatusBar_hWnd, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);

        SendMessage(MainToolBar_hWnd, TB_AUTOSIZE, 0, 0);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDM_EXTRACT)
        {
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_EXTRACT), xHandle, ExtractDialog) == 1)
            {
                Worker_Thread_Handle = CreateThread(NULL, 0, ExtractEntireArchive_Worker_Thread, (LPVOID) gsWorkingInput, CREATE_SUSPENDED, &Worker_Thread_ID);
                DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_PACKING), xHandle, PackingDialog);
            }

            return TRUE;
        }

        if(wParam == IDM_HELP)
        {
            int Value = ListView_GetSelectedCount(FileList_hWnd);

            int ItemPos = -1;
            while( (ItemPos = ListView_GetNextItem(FileList_hWnd, ItemPos, LVNI_SELECTED)) != -1)
            {
                char FileName[255 + 1];
                char FullFileName[255 + 1];
                char Path[255 + 1];

                ListView_GetItemText(FileList_hWnd, ItemPos, 0, FileName, 255);
                ListView_GetItemText(FileList_hWnd, ItemPos, 8, Path, 255);

                _makepath(FullFileName, NULL, Path, FileName, NULL);

                MessageBox(xHandle, FullFileName, Path, 0);
            }

            return TRUE;
        }

        if(wParam == IDM_EXIT)
        {
            EndDialog(xHandle, 0);
            DestroyWindow(xHandle);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

